package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 用户订单详情
 * @Author dangcang
 * @Date 2021/11/16 6:33 下午
 **/
@Data
public class UserOrderDetailDTO implements Serializable {

    private static final long serialVersionUID = -5316707464186147894L;
    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源：和orderType合用
     */
    private String bizId;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 销售方appId
     */
    private Long sellerAppId;

    /**
     * 销售方类型
     */
    private Integer sellerType;

    /**
     * 销售方id
     */
    private Long sellerId;

    /**
     * 购买者用户id
     */
    private Long buyerId;

    /**
     * 购买者类型
     */
    private Integer buyerType;

    /**
     * appId 下单的应用id buyerAppId;
     */
    private Long appId;

    /**
     * 取消订单原因
     */
    private String failReason;

    /**
     * 是否审核拒绝 TRUE = 商家审核失败
     */
    private Boolean reviewReject;

    /**
     * 是否取消发货 TRUE = 商家取消发货
     */
    private Boolean cancelDeliveryReject;

    /**
     * 第三方下单失败 TRUE = 第三方下单失败
     * 对于充值类商品来讲 即为充值失败
     */
    private Boolean thirdFail;

    /**
     * 买家备注
     */
    private String remark;

    /**
     * 业务主体
     */
    private Integer businessEntityType;

    /**
     * 是否含税
     */
    private Boolean hasTax;

    /**
     * 商品基础信息
     */
    private List<SubOrderDetailDTO> subOrderDetailDTOS;

    /**
     * 支付项信息
     */
    private List<PaymentDTO> paymentDTOS;

    /**
     * 优惠项信息
     */
    private List<DiscountDTO> discountDTOS;

}