package cn.com.duiba.cloud.order.center.api.model.dto.virtual;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 卡券类型商品
 * @Author dangcang
 * @Date 2022/4/3 4:47 下午
 **/
@Data
public class VirtualGoodsDeliveryDTO implements Serializable {

    private static final long serialVersionUID = 3807611724951834323L;

    /**
     * 主订单号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 商品快照id
     */
    private String snapshotId;

    /**
     * skuID
     */
    private Long skuId;

    /**
     * 发货人
     */
    private String deliveryName;

    /**
     * 卡券类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.CouponTypeEnum
     */
    private Integer couponType;

    /**
     * 券码
     */
    private String couponCode;

    /**
     * 密码
     */
    private String couponPassword;

    /**
     * 发货时间
     */
    private Long deliveryTime;

    /**
     * 展示文案
     */
    private String title;

    /**
     * 是否展示条形码
     */
    private Boolean showBarCode = Boolean.FALSE;

    /**
     * 是否展示跳转按钮
     */
    private Boolean showJump = Boolean.FALSE;

    /**
     * 展示文案对应的跳转地址
     */
    private String jumpUrl;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期截止时间
     */
    private Date endTime;

    /**
     * 备注
     */
    private String remark;
}