package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 商品信息
 * @Author dangcang
 * @Date 2021/11/10 2:02 下午
 **/
@Data
public class GoodsParam implements Serializable {

    private static final long serialVersionUID = -3367088637140958493L;

    /**
     * skuId
     */
    @NotNull(message = "skuId不能为空")
    private Long skuId;

    /**
     * 第三方子订单号 这个字段只有老MNG才会用到
     */
    private String thirdSubOrderCode;

    /**
     * appId 这个字段可以为空
     * 现在订单会自己查询并且用自己查询到的结果
     * 保留字段为了兼容老mng
     */
    private Long appId;

    /**
     * 商品所有者用户id 租户id
     * 可不传
     */
    private Long ownId;

    /**
     * 商品所有者用户类型
     * 可不传
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.AccountTypeEnum
     */
    private Integer ownType;

    /**
     * 商品类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum
     */
    @NotNull(message = "商品类型不能为空")
    private Integer goodsType;

    /**
     * 商品子类型不能为空 可不传 订单底层会去补充
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SubSpuTypeEnum
     */
    private Integer subGoodsType;

    /**
     * 购买数量
     */
    @NotNull(message = "购买数量不能为空")
    @Min(1)
    private Long saleNumber;

    /**
     * 预占场景泛id，如活动id<br>
     * 如果是预占消耗库存，必填
     */
    private Long generalId;

    /**
     * 预占场景泛类型，{@link cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum}<br>
     * 如果是预占消耗库存，必填
     */
    private Integer generalType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 优惠相关
     */
    private List<DiscountParam> discountParams;

    /**
     * 支付相关
     */
    private List<PaymentParam> paymentParams;

}