package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/4/20 6:35 下午
 **/
@Data
public class OrderDetailQueryParam implements Serializable {

    private static final long serialVersionUID = 8260923919439063843L;
    /**
     * 主订单号
     */
    @NotBlank
    private String orderCode;

    /**
     * 下单appId
     * buyerAppId
     */
    private Long appId;

    /**
     * 销售方appId
     */
    private Long sellerAppId;

    /**
     * 下单用户id
     */
    private Long userId;

    /**
     * 用户类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.AccountTypeEnum
     */
    private Integer userType;
}