package cn.com.duiba.cloud.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/10 6:21 下午
 **/
@Data
public class AfterSaleDTO implements Serializable {

    private static final long serialVersionUID = -7726829729861647502L;
    /**
     * 售后单号
     */
    private String afterSaleNumber;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 销售方类型
     */
    private Integer sellerType;

    /**
     * 销售方id
     */
    private Long sellerId;

    /**
     * 购买方类型
     */
    private Integer buyerType;

    /**
     * 购买方id
     */
    private Long buyerId;

    /**
     * appId
     */
    private Long appId;

    /**
     *  售后方式	（1：正常，2：超期售后）
     */
    private Integer afterSaleType;

    /**
     * 售后类型(1:退款;2:退款退货)
     */
    private Integer afterSaleWay;

    /**
     * 售后状态(1:售后中,2:售后成功,3:取消售后)
     */
    private Integer afterSaleStatus;

    /**
     * 售后原因
     */
    private String afterSaleReason;

    /**
     * 售后凭证（多张照片 ,分隔）
     */
    private String imgSrc;

    /**
     * 申请时间
     */
    private Long created;

}