package cn.com.duiba.cloud.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 订单信息
 * @Author dangcang
 * @Date 2021/11/10 3:36 下午
 **/
@Data
public class OrderDTO implements Serializable {

    private static final long serialVersionUID = 4270086768615138845L;
    /**
     * 提供下次查询时的scrollId scroll查询时返回此字段,
     */
    private String scrollId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 子订单列表
     */
    private List<SubOrderGoodsDTO> subOrderGoodsDTOS;

    /**
     * 扩展信息查询
     */
    private List<OrderExtraDTO> orderExtraDTOS;

    /**
     * 订单商品名称
     */
    private String orderName;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源：和orderType合用
     */
    private String bizId;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 购买者用户id
     */
    private Long buyerId;

    /**
     * 购买者类型
     */
    private Integer buyerType;

    /**
     * 卖家id
     */
    private Long sellerId;

    /**
     * 卖家类型
     */
    private Integer sellerType;
}