package cn.com.duiba.cloud.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/12/16 10:43 上午
 **/
@Data
public class SimpleSubOrderDTO implements Serializable {

    private static final long serialVersionUID = -990857152783001644L;
    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单号
     */
    private Long orderSort;

    /**
     * 订单类型
     * @see cn.com.duiba.cloud.order.service.api.enums.OrderTypeEnum
     */
    private Integer orderType;

    /**
     * 商品快照id
     */
    private String snapshotId;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * sku渠道id
     */
    private String skuChannelId;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 销售单价
     */
    private Long salePrice;

    /**
     * 销售数量
     */
    private Long saleNumber;

    /**
     * 是否有售后
     */
    private Integer isAfterSale;

    /**
     * 备注
     */
    private String remark;

    /**
     * 订单商品名称
     */
    private String goodsName;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 创建时间
     */
    private Long gmtCreate;

    /**
     * 更新时间
     */
    private Long gmtModified;
}