package cn.com.duiba.cloud.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description
 * @Author dangcang
 * @Date 2021/11/10 4:51 下午
 **/
@Data
public class SubOrderGoodsDTO implements Serializable {

    private static final long serialVersionUID = 4840140729307803765L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * orderSort
     */
    private Long orderSort;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 订单快照id
     */
    private String snapshotId;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * sku渠道id
     */
    private String skuChannelId;

    /**
     * 子订单状态
     */
    private Integer orderStatus;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 销售单价(分)
     */
    private Long salePrice;

    /**
     * 购买数量
     */
    private Long saleNumber;

    /**
     * 备注
     */
    private String remark;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * 是否售后
     */
    private Integer isAfterSale;

    /**
     * 售后状态
     */
    private Integer afterSaleStatus;

    /**
     * 交易相关
     */
    private List<PaymentDTO> paymentDTOS;

    /**
     * 优惠相关
     */
    private List<DiscountDTO> discountDTOS;

}