package cn.com.duiba.cloud.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.service.api.model.dto.OrderDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.OrderDetailDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.OrderStatusCountDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.SimpleOrderDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.SubOrderDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.SubOrderGoodsDTO;
import cn.com.duiba.cloud.order.service.api.model.param.OrderQueryParam;
import cn.com.duiba.cloud.order.service.api.model.param.OrderStatusCountParam;
import cn.com.duiba.cloud.order.service.api.model.param.OrderStatusDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.SimpleSubOrderDTO;
import cn.com.duiba.cloud.order.service.api.model.param.SubOrderQueryParam;
import cn.com.duiba.cloud.order.service.api.model.param.UserOrderQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @Description 订单相关读操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:37 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderReadService {

    /**
     * 分页查询订单接口--后台
     * 主订单纬度
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<OrderDTO> backGroundMainOrderFind(OrderQueryParam param) throws BizException;

    /**
     * 分页查询订单接口--后台
     * 子订单维度
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<SubOrderDTO> backGroundSubOrderFind(SubOrderQueryParam param) throws BizException;

    /**
     * 分页查询订单接口-前台用户
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<OrderDTO> pageForUser(UserOrderQueryParam param) throws BizException;

    /**
     * 获取订单详情
     * @param orderCode
     * @return
     * @throws BizException
     */
    OrderDetailDTO getOrderDetail(String orderCode) throws BizException;

    /**
     * 获取子订单商品信息列表
     * 推荐使用分页查询的接口
     * @param orderCode
     * @param orderSortList
     * @return
     * @throws BizException
     */
    List<SubOrderGoodsDTO> getSubOrderList(String orderCode, List<Long> orderSortList) throws BizException;

    /**
     * 根据订单号查询主订单状态
     * @param orderCodeList
     * @return
     * @throws BizException
     */
    List<OrderStatusDTO> getOrderStatusByOrderCodeList(List<String> orderCodeList) throws BizException;

    /**
     * 后台从es获取订单状态下的订单数量
     * @param param
     * @return
     * @throws BizException
     */
    List<OrderStatusCountDTO> backGroundGetStatusCount(OrderStatusCountParam param) throws BizException;

    /**
     * 根据订单号获取订单信息
     * @param orderCode
     * @return
     * @throws BizException
     */
    SimpleOrderDTO getSimpleOrderByOrderCode(String orderCode) throws BizException;

    /**
     * 根据订单号列表获取订单信息
     * @param orderCodeList
     * @return
     * @throws BizException
     */
    List<SimpleOrderDTO> getSimpleOrderByOrderCodeList(List<String> orderCodeList) throws BizException;

    /**
     * 根据订单号列表获取子订单信息
     * @param orderCodeList
     * @return
     * @throws BizException
     */
    List<SimpleSubOrderDTO> getSimpleSubOrderByOrderCodeList(List<String> orderCodeList) throws BizException;

    /**
     * 根据订单号获取子订单信息
     * @param orderCode
     * @return
     * @throws BizException
     */
    List<SimpleSubOrderDTO> getSimpleSubOrderByOrderCode(String orderCode) throws BizException;
}