package cn.com.duiba.cloud.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.service.api.model.dto.PayOrderDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.SimpleSubOrderDTO;
import cn.com.duiba.cloud.order.service.api.model.param.BatchUpdateSubOrderStatusParam;
import cn.com.duiba.cloud.order.service.api.model.param.CreateOrderParam;
import cn.com.duiba.cloud.order.service.api.model.param.OrderCancelParam;
import cn.com.duiba.cloud.order.service.api.model.param.OrderRemarkParam;
import cn.com.duiba.cloud.order.service.api.model.param.UpdateOrderStatusParam;

import java.util.List;

/**
 * @Description 订单相关写操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:35 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderWriteService {

    /**
     * 创建订单
     * @param params
     * @return
     * @throws BizException
     */
    List<PayOrderDTO> createOrder(List<CreateOrderParam> params) throws BizException;

    /**
     * 用户订单备注
     * 子订单级别的备注
     * @param param
     * @return
     * @throws BizException
     */
    Boolean userSubOrderRemark(OrderRemarkParam param) throws BizException;

    /**
     * 修改订单状态
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateOrderStatus(UpdateOrderStatusParam param) throws BizException;

    /**
     * 修改子订单的状态
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateSubOrderStatus(UpdateOrderStatusParam param) throws BizException;

    /**
     * 批量更新子订单状态
     * @param updateSubOrderStatusParam
     * @return 更新的子订单部分
     */
    List<SimpleSubOrderDTO> batchUpdateSubOrderStatus(BatchUpdateSubOrderStatusParam updateSubOrderStatusParam);

    /**
     * 取消订单
     * @param param
     * @return
     * @throws BizException
     */
    Boolean cancelOrder(OrderCancelParam param) throws BizException;
}