/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 账户类型, 用户角度出发看账户
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum AccountStateEnum {
    AVAILABLE(1, "可用"),
    FROZEN(2, "冻结"),
    SETTLE(3, "待入账"),
    WITHDRAWING(4, "提现中"),
    WITHDRAWN(5, "已提现");


    private Integer value;

    private String desc;

    AccountStateEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (AccountStateEnum item : AccountStateEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static AccountStateEnum valueOf(Integer value) {
        for (AccountStateEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
