/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * 账户类型, 用户角度出发看账户
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum AccountTypeEnum {

    /**
     * 虚拟账户，比如用户购买，支持的钱在这
     */
    VIRTUAL_BANK(1, "虚拟银行", "payment_virtual_bank"),
    /**
     * 作为周转用，目的为了兼容组合支付场景
     */
    TEMP_BALANCE(2, "临时账户", "payment_temp_balance"),

    RESIDUE(3, "货款", "payment_residue"),

    SUPPLY_PAYMENT(4, "供货款", "payment_supply_payment"),

    SERVICE_FEE(5, "服务费", "payment_service_fee"),

    /**** 信用账户****/
    CREDIT_SXZH(200, "授信账户", "payment_credit_sxzh"),
    CREDIT_QYZS(201, "权益赠送", "payment_credit_qyzs"),
    CREDIT_BZXJ(202, "包装现金", "payment_credit_bzxj"),
    CREDIT_BZSX(203, "包装授信", "payment_credit_bzsx"),
    ;


    private Integer value;

    private String desc;

    /**
     * 计量类型，要与计量配置对应
     */
    private String measureType;

    AccountTypeEnum(Integer value, String desc, String measureType) {
        this.value = value;
        this.desc = desc;
        this.measureType = measureType;
    }

    public static String getDesc(int value) {
        for (AccountTypeEnum item : AccountTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static AccountTypeEnum valueOf(Integer value) {
        for (AccountTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }

    /**
     * 获取授信账户类型
     *
     * @return
     */
    public static List<Integer> getCreditAccountType() {
        return Arrays.asList(AccountTypeEnum.CREDIT_SXZH.value, AccountTypeEnum.CREDIT_QYZS.value, AccountTypeEnum.CREDIT_BZXJ.value, AccountTypeEnum.CREDIT_BZSX.value);
    }


    /**
     * 可以提现账户
     *
     * @return
     */
    public static List<Integer> getWithdrawAccountType() {
        return Arrays.asList(AccountTypeEnum.RESIDUE.value, AccountTypeEnum.SUPPLY_PAYMENT.value, AccountTypeEnum.SERVICE_FEE.value);
    }
}
