/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 使用字段：consumer_status,refund_status（消费项状态）,withdraw_status 业务进程类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 3:50 下午
 **/
@Getter
public enum BizProcessEnum {
    WITHOUT(0, "无需进程"),
    WAIT(1, "待处理"),
    DOING(2, "处理中"),
    DONE(3, "完成"),
    FAIL(4, "失败"),
    CANCEL(5, "撤销");

    private Integer value;

    private String desc;

    BizProcessEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (BizProcessEnum item : BizProcessEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static BizProcessEnum valueOf(Integer value) {
        for (BizProcessEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
