/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * 支付业务类型，有相应独立单号的
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum PayBizTypeEnum {
    /**
     * 业务类型，在订单，资金流水都有涉及
     */
    ORDER_PAY(1, "支付订单"),
    WITHDRAW(2, "提现"),
    REFUND(3, "退款"),
    RECHARGE(4, "充值"),
    TRANSFER(5, "转账"),
    DEDUCTION(6, "扣减"),
    FROZEN(7, "冻结"),
    THAW(8, "解冻"),
    ;


    private Integer value;

    private String desc;

    PayBizTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayBizTypeEnum item : PayBizTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayBizTypeEnum valueOf(Integer value) {
        for (PayBizTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }

    /**
     * 走转账表的业务类型
     *
     * @return
     */
    public static List<Integer> getTransferCategory() {
        return Arrays.asList(PayBizTypeEnum.RECHARGE.value, PayBizTypeEnum.TRANSFER.value,
                PayBizTypeEnum.DEDUCTION.value, PayBizTypeEnum.FROZEN.value, PayBizTypeEnum.THAW.value);
    }
}
