/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 支付场景
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum PaySceneEnum {
    DEFAULT(0, "默认场景"),
    ;


    private Integer value;

    private String desc;

    PaySceneEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PaySceneEnum item : PaySceneEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PaySceneEnum valueOf(Integer value) {
        for (PaySceneEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
