/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 支付场景
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum TransferSceneEnum {
    /**
     * 转账场景 （转账、充值、扣款）
     */
    TRANSFER(1, "转账"),
    RECHARGE(2, "充值"),
    DEDUCTION(3, "扣款"),
    FROZEN(4, "冻结"),
    THAW(5, "解冻"),
    ;


    private Integer value;

    private String desc;

    TransferSceneEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (TransferSceneEnum item : TransferSceneEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    /**
     * 业务类型 与 转账场景转换
     *
     * @param payBizType
     * @return
     */
    public static TransferSceneEnum bizTypeToScene(PayBizTypeEnum payBizType) {
        if (PayBizTypeEnum.RECHARGE == payBizType) {
            return TransferSceneEnum.RECHARGE;
        }
        if (PayBizTypeEnum.TRANSFER == payBizType) {
            return TransferSceneEnum.TRANSFER;
        }
        if (PayBizTypeEnum.DEDUCTION == payBizType) {
            return TransferSceneEnum.DEDUCTION;
        }
        if (PayBizTypeEnum.FROZEN == payBizType) {
            return TransferSceneEnum.FROZEN;
        }
        if (PayBizTypeEnum.THAW == payBizType) {
            return TransferSceneEnum.THAW;
        }
        return null;
    }

    public static TransferSceneEnum valueOf(Integer value) {
        for (TransferSceneEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
