/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 用户类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/8 10:50 上午
 **/
@Getter
public enum UserTypeEnum {
    PLATFORM(1, "平台"),
    TENANT(2, "租户"),
    C_USER(3, "C端用户");


    private Integer value;

    private String desc;

    UserTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (UserTypeEnum item : UserTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static UserTypeEnum valueOf(Integer value) {
        for (UserTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
