package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * 账户查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/23 2:30 下午
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
public class AccountStateQueryParam extends PayUserBase {

    private static final long serialVersionUID = -6255465616303668475L;

    /**
     * 账户类型
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.AccountTypeEnum
     */
    @NotNull
    private Integer accountType;
}
