package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;

/**
 * 扣减单请求
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/8 2:11 下午
 **/
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@Data
public class DeductionOrderParam extends PayUserBase {
    private static final long serialVersionUID = 7423620653796693669L;

    /**
     * 账户类型
     */
    @NonNull
    private Integer accountType;

    /**
     * 转账编号
     */
    @NonNull
    private String deductionNo;

    /**
     * 转账金额（传正数）
     * deductionAmount
     */
    @NonNull
    private Long deductionAmount;

    /**
     * 扣减原因，会在用户账单中看到，请严格处理
     */
    private String deductionReason;
}
