package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 订单分账信息
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 4:58 下午
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class OrderSplittingParam extends PayUserBase {
    private static final long serialVersionUID = 8903286874020281501L;

    /**
     * 业务角色
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.BizRoleEnum
     */
    @NonNull
    private Integer bizRole;

    /**
     * 金额（分），包含fee
     */
    @NonNull
    private Long amount;

    /**
     * 费用（分）,平台的抽层，也可以放到subSplit中，效果一样
     */
    private Long fee = 0L;

    /**
     * 分账 每一层总和 = 上一层的金额
     *  场景举例
     * 应得 = 上一层-下一层  无需记录
     * >支付金额 + 补贴
     * >>卖家收入
     * >>>平台抽层
     * >>>>供货商
     *
     * >支付金额 + 补贴
     * >>卖家收入
     * >>>平台抽层
     * >>>供货商
     *
     * >支付金额 + 补贴
     * >>卖家收入
     * >>>平台抽层
     * >>供货商收入
     * >>>平台抽层
     */
    //  private Set<OrderSplittingParam> subSplit;
}