package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 充值单请求
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/8 2:11 下午
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class RechargeOrderParam extends PayUserBase {
    private static final long serialVersionUID = -3403499356781810999L;


    @NonNull
    private Integer accountType;

    /**
     * 充值编号
     */
    @NonNull
    private String rechargeNo;

    /**
     * 充值金额
     * refundAmount
     */
    @NonNull
    private Long rechargeAmount;

    /**
     * 充值原因，会在用户账单中看到，请严格处理
     */
    private String rechargeReason;
}
