package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.util.Date;

/**
 * 统一下单基础类
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 11:00 上午
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class SaleOrderParam extends PayUserBase {

    private static final long serialVersionUID = -4270205905759478956L;

    /**
     * 卖家用户类型（租户、普通用户等）
     * user_type
     */
    @NonNull
    private Integer toUserType;

    /**
     * 卖家用户id
     * to_user_id
     */
    @NonNull
    private Long toUserId;

    /**
     * 总金额
     * amount
     */
    @NonNull
    private Long amount;

    /**
     * 过期时间
     * expired_time
     */
    @NonNull
    private Date expiredTime;

    /**
     * 业务单号（合并下单时为支付系统生成）
     * biz_no
     */
    @NonNull
    private String bizNo;

    /**
     * 业务版本
     * biz_version
     */
    @NonNull
    private Integer bizVersion;
}
