package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 提现查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/8 2:11 下午
 **/
@Data
@EqualsAndHashCode(callSuper = false)
public class WithdrawQueryParam extends PageRequest {

    private static final long serialVersionUID = -1049156002557122069L;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 提现编号
     */
    private String withdrawNo;

    /**
     * 提现状态
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.BizProcessEnum
     */
    private Integer withdrawStatus;

    /**
     * 范围-开始时间
     */
    private Date startTime;

    /**
     * 范围-结束时间
     */
    private Date endTime;
}
