package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenApi;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenPath;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.AccountStateDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.PayBillDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.param.AccountStateQueryParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.PayBillPageQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 账户相关服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/22 4:28 下午
 **/
@OpenApi(prefix = "/payment")
@AdvancedFeignClient("duiba-payment-service")
public interface RemoteAccountService {
    /**
     * 查询用户账户状态信息<br/>
     * 账户唯一组成：userType+userId+accountType+accountState<br/>
     * accountState：一个accountType包含多个accountState状态 {@link cn.com.duiba.cloud.duiba.payment.service.api.enums.AccountStateEnum}
     *
     * @param param
     * @return
     */
    @OpenPath(apiPath = "/query/accountState",apiDesc = "查询用户账户状态信息")
    AccountStateDTO queryAccountState(AccountStateQueryParam param);


    /**
     * 查询账户账单 <br/>
     * B端、C端等需要账单查询的都调该接口
     *
     * @param param
     * @return
     */
    @OpenPath(apiPath = "/query/accountBill",apiDesc = "查询账户账单接口")
    PageResponse<PayBillDTO> queryAccountBill(PayBillPageQueryParam param);
}
