package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.param.FrozenOrderParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.RefundOrderParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.SaleOrderParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.ThawOrderParam;

import java.util.List;

/**
 * 统一下单服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 10:45 上午
 **/
@AdvancedFeignClient("duiba-payment-service")
public interface RemoteUnifiedOrderService {
    /**
     * 支付下单（支持单笔、多笔）
     * 存放虚拟合并单号
     *
     * @param saleOrderParam
     * @return payKey用于查询收银台用
     */
    String saleOrder(List<SaleOrderParam> saleOrderParam) throws BizException;


    /**
     * 退款下单(确认要退款时调)
     *
     * @param refundOrderParam
     * @return
     */
    String refundOrder(RefundOrderParam refundOrderParam) throws BizException;


    /**
     * 冻结资金
     *
     * @param frozenOrderParam
     * @return
     */
    String frozenOrder(FrozenOrderParam frozenOrderParam) throws BizException;


    /**
     * 解冻资金
     *
     * @param thawOrderParam
     * @return
     */
    String thawOrder(ThawOrderParam thawOrderParam) throws BizException;
}
