/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 账户绑定类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/8 10:50 上午
 **/
@Getter
public enum PayBindTypeEnum {
    /**
     * 账户绑定类型
     */
    ALIPAY(1, "支付宝"),
    WXPAY(2, "微信"),
    BANK(3, "银行卡");


    private Integer value;

    private String desc;

    PayBindTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayBindTypeEnum item : PayBindTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayBindTypeEnum valueOf(Integer value) {
        for (PayBindTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
