/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 用户类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/8 10:50 上午
 **/
@Getter
public enum PayUserTypeEnum {
    PLATFORM(1, "平台"),
    TENANT(2, "租户"),
    C_USER(3, "C端用户"),
    /**
     * 应用时 userId 传应用id
     */
    APPLICATION(4, "应用"),
    ;


    private Integer value;

    private String desc;

    PayUserTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayUserTypeEnum item : PayUserTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayUserTypeEnum valueOf(Integer value) {
        for (PayUserTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
