package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 账户查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/23 4:00 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class AccountPageQueryParam extends PageRequest {
    private static final long serialVersionUID = -5868119712657237611L;
    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 用户id列表
     * 分表键，必传
     */
    @NotNull(message = "用户id不能为空")
    private List<Long> userIdList;

    /**
     * 账户类型
     */
    private Integer accountType;

    /**
     * 账户类型 列表
     */
    private List<Integer> accountTypeList;

    /**
     * 账户状态
     */
    private Integer accountState;

    /**
     * 账户状态 列表
     */
    private List<Integer> accountStateList;

    /**
     * 计量id
     */
    private String measureId;
}
