package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayAccountActionEnum;
import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBillStatusEnum;
import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayUserTypeEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 账单查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/23 2:44 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class PayBillPageQueryParam extends PageRequest {

    private static final long serialVersionUID = -3866976535151107941L;
    /**
     * 用户id
     */
    @NotNull
    private Long userId;

    private List<Long> userIds;

    /**
     * 用户类型
     *
     * @see PayUserTypeEnum
     */
    @NotNull
    private Integer userType;

    /**
     * 账户类型
     */
    private Integer accountType;

    /**
     * 账户动作
     *
     * @see PayAccountActionEnum
     */
    private Integer accountAction;

    /**
     * 交易单号
     */
    private String tradeNo;

    /**
     * 业务单号
     */
    private String bizNo;

    /**
     * 业务类型
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBizTypeEnum
     */
    private Integer bizType;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 账单状态
     *
     * @see PayBillStatusEnum
     */
    private List<Integer> billStatusList;
}
