package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.BudgetConfigDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.param.budget.BudgetCheckParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.budget.BudgetQueryParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.budget.BudgetSettingParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.budget.BudgetUseParam;

/**
 * 预算服务
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/16 3:03 下午
 **/
@AdvancedFeignClient
public interface RemoteBudgetService {

    /**
     * 校验预算
     * @param param
     * @return
     */
    Boolean checkBudget(BudgetCheckParam param);

    /**
     * 使用预算
     * @param param
     */
    void useBudget(BudgetUseParam param) throws BizException;


    /**
     * 设置预算配置
     * @param param
     */
    void setBudgetConfig(BudgetSettingParam param);

    /**
     * 预算配置查询
     * @param param
     * @return
     */
    BudgetConfigDTO queryBudgetConfig(BudgetQueryParam param);
}
