package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.param.AlipayNotifyParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.WxNotifyV2Param;

/**
 * 支付通知
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/10 6:05 下午
 **/
@AdvancedFeignClient
public interface RemotePayNoticeService {

    /**
     * 微信回调处理，当支付三方会异步通知退款情况
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean wxPayNotice(WxNotifyV2Param param) throws BizException;

    /**
     * 微信退款回调，当发生退款三方会异步通知退款情况
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean wxRefundNotice(WxNotifyV2Param param) throws BizException;

    /**
     * 支付宝回调，当支付三方会异步通知退款情况
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean aliPayNotice(AlipayNotifyParam param) throws BizException;
}
