package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.param.OrderCallbackParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.OrderDoneParam;

/**
 * 支付订单服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/10 6:09 下午
 **/
@AdvancedFeignClient
public interface RemotePayOrderService {

    /**
     * 订单支付成功后，订单处理完成后台 回调<br/>
     * 由订单调，异常情况建议订单那边需要进行重试，重试多次失败需要通知相关人员介入
     *
     * @param param
     * @throws BizException
     */
    void orderCallback(OrderCallbackParam param) throws BizException;


    /**
     * 订单完成完成处理<br/>
     * 由订单调，但且仅当订单完结是调用，此时会把资金转入相关账户的余额，可以进行提现<br/>
     * 没有异常可认为，资金这边已经处理<br/>
     * 异常情况建议订单那边需要进行重试，重试多次失败需要通知相关人员介入<br/>
     *
     * @param param
     * @throws BizException
     */
    void orderDone(OrderDoneParam param) throws BizException;
}
