/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import java.util.Arrays;
import java.util.List;

public enum PayAccountTypeEnum {
    VIRTUAL_BANK(1, "\u865a\u62df\u94f6\u884c", "payment_virtual_bank"),
    TEMP_BALANCE(2, "\u4e34\u65f6\u8d26\u6237", "payment_temp_balance"),
    RESIDUE(3, "\u8d27\u6b3e", "payment_residue"),
    SUPPLY_PAYMENT(4, "\u4f9b\u8d27\u6b3e", "payment_supply_payment"),
    CASH_BALANCE(5, "\u73b0\u91d1\u8d26\u6237", "payment_service_fee"),
    SERVICE_FEE(6, "\u670d\u52a1\u8d39", "payment_service_fee"),
    CREDIT_SXZH(200, "\u6388\u4fe1\u8d26\u6237", "payment_credit_sxzh"),
    CREDIT_QYZS(201, "\u6743\u76ca\u8d60\u9001", "payment_credit_qyzs"),
    CREDIT_LSSX(202, "\u4e34\u65f6\u6388\u4fe1\u8d26\u6237", "payment_credit_lssx"),
    APP_BALANCE(300, "\u5e94\u7528\u4f59\u989d\uff08\u73b0\u91d1\u8d26\u6237\u3001\u6388\u4fe1\u8d26\u6237\u3001\u6743\u76ca\u8d60\u9001\u3001\u4e34\u65f6\u6388\u4fe1\u8d26\u6237\uff09", "");

    private Integer value;
    private String desc;
    private String measureType;

    private PayAccountTypeEnum(Integer value, String desc, String measureType) {
        this.value = value;
        this.desc = desc;
        this.measureType = measureType;
    }

    public static String getDesc(int value) {
        for (PayAccountTypeEnum item : PayAccountTypeEnum.values()) {
            if (item.value != value) continue;
            return item.desc;
        }
        return "";
    }

    public static PayAccountTypeEnum valueOf(Integer value) {
        for (PayAccountTypeEnum param : PayAccountTypeEnum.values()) {
            if (!param.getValue().equals(value)) continue;
            return param;
        }
        return null;
    }

    public byte getByteValue() {
        return this.value.byteValue();
    }

    public static List<Integer> getCreditAccountType() {
        return Arrays.asList(PayAccountTypeEnum.CREDIT_SXZH.value, PayAccountTypeEnum.CREDIT_QYZS.value);
    }

    public static List<Integer> getWithdrawAccountType() {
        return Arrays.asList(PayAccountTypeEnum.RESIDUE.value, PayAccountTypeEnum.SUPPLY_PAYMENT.value, PayAccountTypeEnum.SERVICE_FEE.value);
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getMeasureType() {
        return this.measureType;
    }
}

