package cn.com.duiba.cloud.duiba.payment.service.api.dto;

import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayUserTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 账单
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/9 10:50 上午
 **/
@Data
public class PayBillDTO implements Serializable {

    private static final long serialVersionUID = -1488291502435621259L;
    /**
     * 用户类型（租户、普通用户等）
     *
     * @see PayUserTypeEnum
     */
    private Integer userType;

    /**
     * 用户
     */
    private Long userId;

    /**
     * 主体
     *
     * @See BusinessEntityEnum
     */
    private Integer businessEntityType;

    /**
     * 账单编号（流水号）
     */
    private String billNo;

    /**
     * 业务中业务角色
     *
     * @see
     */
    private Integer bizRole;

    /**
     * 业务编号
     */
    private String bizNo;

    /**
     * 业务类型
     */
    private Integer bizType;

    /**
     * 金额
     */
    private Long amount;

    /**
     * 费用
     */
    private Long fee;

    /**
     * 补贴
     */
    private Long subsidy;

    /**
     * 描述（对外）
     */
    private String remark;

    /**
     * 期初金额
     */
    private Long beforeAmount;

    /**
     * 期末金额
     */
    private Long afterAmount;

    /**
     * 备注（内部）
     */
    private String memo;

    /**
     * 账单状态
     */
    private Integer billStatus;

    /**
     * 拓展数据 JSON
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.model.BillExtraModel
     */
    private String extra;

    private Date gmtCreate;
}