package cn.com.duiba.cloud.duiba.payment.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 签名
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/22 4:53 下午
 **/
@Data
public class TradePayDTO implements Serializable {

    private static final long serialVersionUID = -8835793357951443171L;

    private String appId;

    /**
     * 三方商户id 微信
     */
    private String merchantId;

    /**
     * 三方返回的预支付会话ID 微信
     **/
    private String prepayId;

    /**
     * 三方返回的交易编号
     **/
    private String tradeNo;

    /**
     * 我们对三方暴露的交易编号
     **/
    private String outTradeNo;

    /**
     * 签名类型
     **/
    private String signType;

    /**
     * 签名
     **/
    private String sign;

    /**
     * 微信返回的随机字符串-仅限微信支付
     **/
    private String nonceStr;

    /**
     * 订单str-调起支付用 支付宝、微信
     **/
    private String orderStr;

    /**
     * 二维码链接 native时有返回
     **/
    private String codeUrl;

    /**
     * 时间戳
     **/
    private String timeStamp;

    /**
     * 拓展信息
     **/
    private String extra;
}
