package cn.com.duiba.cloud.duiba.payment.service.api.param;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.io.Serializable;
import java.util.Set;

/**
 * 订单回调处理
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 4:58 下午
 **/
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class OrderDoneParam implements Serializable {
    private static final long serialVersionUID = 440182387884461422L;
    /**
     * 业务单号
     */
    @NonNull
    private String bizNo;

    /**
     * 业务版本好
     */
    @NonNull
    private Integer bizVersion;

    /**
     * 业务类型
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBizTypeEnum
     */
    @NonNull
    private Integer bizType;

    /**
     * 备注信息
     */
    private String memo;

    /**
     * 分账信息
     */
    private Set<OrderSplittingParam> orderSplitting;
}
