package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 绑定账户查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/05/17 10:46 上午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class PayCreditQueryParam extends PageRequest {

    private static final long serialVersionUID = 8224815378928281119L;
    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 授信类型
     */
    private Integer accountType;

    /**
     * 是否有效
     */
    private Boolean isValid;

    /**
     * 是否过期
     */
    private Boolean isOverdue;

    /**
     * 是否需要冲销
     */
    private Boolean needFill;

    private Boolean isDelete;
}
