package cn.com.duiba.cloud.duiba.payment.service.api.param.app;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 应用账户金额扣减
 * 赠送余额>现金余额>常规授信余额>临时授信余额
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/12 1:41 下午
 **/
@Data
public class AppAccountDeductionParam implements Serializable {

    private static final long serialVersionUID = 2423640230498958040L;
    /**
     * 应用Id
     */
    @NotNull(message = "应用Id不能为空")
    private Long appId;

    /**
     * 扣减金额
     */
    @NotNull(message = "扣减金额不能为空")
    private Long amount;

    /**
     * 业务编号（渠道流水号）
     */
    @NotBlank(message = "业务编号不能为空")
    private String bizNo;

    /**
     * 主体类型（从management查）
     */
    @NotNull(message = "主体类型不能为空")
    private Integer businessEntityType;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空")
    private String memo;

}
