package cn.com.duiba.cloud.duiba.payment.service.api.param.app;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 应用订单创建（应用-》兑吧）
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/16 2:07 下午
 **/
@Data
public class AppOrderCreateParam implements Serializable {
    private static final long serialVersionUID = 704287909381249009L;
    /**
     * 应用Id
     */
    @NotNull(message = "应用Id不能为空")
    private Long appId;

    /**
     * 业务编号
     */
    @NotBlank(message = "业务编号不能为空")
    private String bizNo;

    /**
     * 相关主订单
     */
    @NotBlank(message = "相关主订单不能为空")
    private String mainOrder;

    /**
     * 相关子订单
     */
    @NotNull(message = "相关子订单不能为空")
    private List<String> subOrderList;

    /**
     * 主体类型（从management查）
     */
    @NotNull(message = "主体类型不能为空")
    private Integer businessEntityType;

    /**
     * 金额
     */
    @NotNull(message = "金额不能为空")
    private Long amount;

    /**
     * 备注
     */
    private String memo;
}
