package cn.com.duiba.cloud.duiba.payment.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 预算配置
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/16 3:05 下午
 **/
@Data
public class BudgetConfigDTO implements Serializable {
    private static final long serialVersionUID = 4141616785484170379L;
    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户类型
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayUserTypeEnum
     */
    private Integer userType;

    /**
     * 预算来源
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBudgetSourceEnum
     */
    private Integer budgetSource;

    /**
     * 每日普兑预算（分）
     */
    private Long dailyExchangeBudget ;


    /**
     * 每月普兑预算（分）
     */
    private Long monthlyExchangeBudget;

    /**
     * 每日普兑预算（分）
     */
    private Long dailyActivityBudget ;

    /**
     * 每月普兑预算（分）
     */
    private Long monthlyActivityBudget;
}
