/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 业务进程类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 3:50 下午
 **/
@Getter
public enum PayBillStatusEnum {
    WITHOUT(0, "无需处理"),
    WAIT(1, "待支付"),
    DOING(2, "支付成功待完成"),
    FROZEN(201, "冻结中"),
    DONE(3, "已完成"),
    FAIL(4, "支付失败"),
    CANCEL(5, "退款/撤销"),
    ;

    private Integer value;

    private String desc;

    PayBillStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayBillStatusEnum item : PayBillStatusEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayBillStatusEnum valueOf(Integer value) {
        for (PayBillStatusEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
