/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 支付子状态，微信交易类型（不能修改，需与三方对应)
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum PaySubMethodEnum {
    /**
     * 微信公众号支付
     */
    JSAPI(1, "JSAPI"),

    /**
     * 扫码支付
     */
    NATIVE(2, "NATIVE"),
    /**
     * APP支付
     */
    APP(3, "APP"),
    /**
     * 付款码支付
     */
    MICROPAY(4, "MICROPAY"),
    /**
     * H5支付
     */
    MWEB(5, "MWEB"),

    /**
     * 小程序支付
     */
    MINI(6, "MINI"),
    /**
     * pc端支付
     */
    PC(7, "PC"),
    ;


    private Integer value;

    private String desc;

    PaySubMethodEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PaySubMethodEnum item : PaySubMethodEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PaySubMethodEnum valueOf(Integer value) {
        for (PaySubMethodEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
