package cn.com.duiba.cloud.duiba.payment.service.api.param;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.io.Serializable;
import java.util.Set;

/**
 * 订单回调处理
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 4:58 下午
 **/
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class OrderCallbackParam implements Serializable {
    private static final long serialVersionUID = 38548784338006222L;
    /**
     * 业务单号
     */
    @NonNull
    private String bizNo;

    @NonNull
    private String outTradeNo;
    /**
     * 业务版本好
     */
    @NonNull
    private Integer bizVersion;


    @NonNull
    private Integer payMethod;

    /**
     * 备注信息
     */
    private String memo;

    /**
     * 订单支付总金额,不含补贴金额
     */
    @NonNull
    private Long amount;

    /**
     * 优惠补贴金额
     */
    @NonNull
    private Long subsidy = 0L;

    /**
     * 分账信息, 不同业务角色得多少钱
     */
    private Set<OrderSplittingParam> orderSplitting;
}
