package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.AccountDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.AppAccountDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.PayBillDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.param.AccountPageQueryParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.app.AppAccountQueryParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.PayBillPageQueryParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.app.AppCheckAmountParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 账户读相关服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/22 4:28 下午
 **/
@AdvancedFeignClient
public interface RemoteAccountReadService {

    /**
     * 账户分页查询
     * @param request
     * @return
     */
    PageResponse<AccountDTO> queryAccountForPage(AccountPageQueryParam request);

    /**
     * 查询账户账单 <br/>
     * B端、C端等需要账单查询的都调该接口
     *
     * @param param
     * @return
     */
    PageResponse<PayBillDTO> queryAccountBill(PayBillPageQueryParam param);

    /**
     * 查询应用账户
     *
     * @param param
     * @return
     */
    List<AppAccountDTO> queryAppAccount(AppAccountQueryParam param);


    /**
     * 校验App是否可以切换主体
     * @param param
     * @return
     */
    Boolean checkAppChangeEntity(AppAccountQueryParam param);

    /**
     * 校验应用余额
     * @param param
     * @return
     */
    Boolean checkAppBalance(AppCheckAmountParam param);
}
