package cn.com.duiba.cloud.duiba.payment.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 账户状态
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/05/12 19:17 下午
 **/
@Data
public class AccountDTO implements Serializable {
    private static final long serialVersionUID = -2796046925132931058L;
    private String accountNo;

    /**
     * 用户类型（租户、普通用户等）
     * <p>
     */
    private Integer userType;

    /**
     * 用户id
     * <p>
     */
    private Long userId;

    /**
     * 账户类型（虚拟、临时、货款）
     * <p>
     */
    private Integer accountType;

    /**
     * 账户状态
     * <p>
     */
    private Integer accountState;

    /**
     * 金额
     * <p>
     */
    private Long amount;

    /**
     * 计量id
     * <p>
     */
    private String measureId;

    /**
     * 版本
     * <p>
     */
    private Long version;

    /**
     * 更新时间
     * <p>
     */
    private Date gmtModified;
}