package cn.com.duiba.cloud.duiba.payment.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 租户应用账户
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/23 2:17 下午
 **/
@Data
public class AppAccountDTO implements Serializable {
    private static final long serialVersionUID = -6310759222780312503L;
    /**
     * 应用Id
     */
    private Long appId;

    /**
     * 可用额度
     */
    private Long available = 0L;

    /**
     * 总余额（包含冻结）
     */
    private Long totalBalance = 0L;

    /**
     * 现金
     */
    private Long cash = 0L;

    /**
     * 冻结金额
     */
    private Long frozen = 0L;

    /**
     * 未结算款项
     */
    private Long unsettled = 0L;

    /**
     * 授信额度（常规授信+临时授信）
     */
    private Long credit = 0L;

    /**
     * 常规授信
     */
    private Long cgsxCredit = 0L;

    /**
     * 累计常规授信
     */
    private Long accumulateCgsxCredit = 0L;

    /**
     * 临时授信
     */
    private Long lssxCredit = 0L;

    /**
     * 无法使用的的授信
     */
    private Long unavailableCredit = 0L;

    /**
     * 累计临时授信
     */
    private Long accumulateLssxCredit = 0L;

    /**
     * 权益赠送
     */
    private Long qyzsCredit = 0L;


}
