package cn.com.duiba.cloud.duiba.payment.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 提现信息
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/8 2:11 下午
 **/
@Data
public class WithdrawInfoDTO implements Serializable {

    private static final long serialVersionUID = 4123364389608058323L;

    /**
     * 用户类型（租户、普通用户等）
     */
    private Integer userType;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 提现编号
     */
    private String withdrawNo;

    /**
     * 账户类型
     */
    private Integer accountType;

    /**
     * 金额
     */
    private Long amount;

    /**
     * 支付方式
     */
    private Integer payMethod;

    /**
     * 提现状态
     */
    private Integer withdrawStatus;

    /**
     * 账户信息，根据支付方式处理
     */
    private WithdrawAccountDTO accountInfo;

    /**
     * 交易单号
     */
    private String tradeNo;

}
