/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 账户类型, 用户角度出发看账户
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum PayAccountMemoEnum {
    AVAILABLE(1, "支付订单"),
    ;


    private Integer value;

    private String desc;

    PayAccountMemoEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayAccountMemoEnum item : PayAccountMemoEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayAccountMemoEnum valueOf(Integer value) {
        for (PayAccountMemoEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
