/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * 账户类型, 用户角度出发看账户
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum PayAccountTypeEnum {

    /**
     * 虚拟账户，比如用户购买，支出的钱在这
     */
    VIRTUAL_BANK(1, "虚拟银行", "payment_virtual_bank"),
    /**
     * 作为周转用，目的为了兼容组合支付场景
     */
    TEMP_BALANCE(2, "临时账户", "payment_temp_balance"),

    RESIDUE(3, "货款", "payment_residue"),

    SUPPLY_PAYMENT(4, "供货款", "payment_supply_payment"),

    CASH_BALANCE(5, "现金账户", "payment_service_fee"),

    SERVICE_FEE(6, "服务费", "payment_service_fee"),

    /**** 信用账户****/
    CREDIT_CGSX(200, "常规授信", "payment_credit_cgsx"),
    CREDIT_QYZS(201, "权益赠送", "payment_credit_qyzs"),
    CREDIT_LSSX(202, "临时授信", "payment_credit_lssx"),

    /**** 组合账户 只作为业务类型的表示，由多个账户组成****/
    APP_BALANCE(300, "应用余额（现金账户、授信账户、权益赠送、临时授信账户）", ""),
    ;


    private Integer value;

    private String desc;

    /**
     * 计量类型，要与计量配置对应
     */
    private String measureType;

    PayAccountTypeEnum(Integer value, String desc, String measureType) {
        this.value = value;
        this.desc = desc;
        this.measureType = measureType;
    }

    public static String getDesc(int value) {
        for (PayAccountTypeEnum item : PayAccountTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayAccountTypeEnum valueOf(Integer value) {
        for (PayAccountTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }

    /**
     * 获取授信账户类型
     *
     * @return
     */
    public static List<Integer> getCreditAccountType() {
        return Arrays.asList(PayAccountTypeEnum.CREDIT_CGSX.value, PayAccountTypeEnum.CREDIT_QYZS.value);
    }


    /**
     * 可以提现账户
     *
     * @return
     */
    public static List<Integer> getWithdrawAccountType() {
        return Arrays.asList(PayAccountTypeEnum.RESIDUE.value, PayAccountTypeEnum.SUPPLY_PAYMENT.value, PayAccountTypeEnum.SERVICE_FEE.value);
    }
}
