/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 预算类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/9 10:50 上午
 **/
@Getter
public enum PayBudgetTypeEnum {
    /**
     * 预算类型
     */
    EXCHANGE(1, "下单预算"),
    ACTIVITY(2, "活动预算")
    ;


    private Integer value;

    private String desc;

    PayBudgetTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayBudgetTypeEnum item : PayBudgetTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayBudgetTypeEnum valueOf(Integer value) {
        for (PayBudgetTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
